<?php

namespace App\Http\Controllers\Admin\Auth;

use App\Http\Controllers\Controller;
use App\Http\Requests\userrequest;
// use Dotenv\Validator;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Hash;
use Livewire\Attributes\Validate;
use Morilog\Jalali\Jalalian;
use Shuchkin\SimpleXLSX;

use Illuminate\Support\Facades\Validator;

class AdminController extends Controller
{
    public function logincheck(Request $request)
    {

        $request->validate([
            'username' => 'required',
            'password' => 'required',
        ], [
            'username.required' => 'لطفا نام کاربری را وارد نمایید',
            'password.required' => 'لطفا رمز عبور را وارد نمایید',

        ]);
        // DB::table('admins')->insert([
        //     'name' => 'pakanbakhtar',
        //     'username' => 'mrspakan',
        //     'password' => Hash::make('12345pakanbakhtar12345'),
        // ]);
        // dd('ok');
        // $u = DB::table('admins')->where('username', '=', $request->username)->where('password', '=', Hash::check($request->password))->first();
        $credentials = [
            'username' => $request->username,
            'password' => $request->password,
        ];

        if (Auth::guard('admin')->attempt($credentials)) {

            return redirect()->route('admin.dashboard');
        } else {
            return redirect()->route('adminlogin')->with('message', 'چنین کاربری یافت نشد');
        }
    }

    function dashboard()
    {
        $headertext = 'داشبورد';
        $notifs = DB::table('notification')->get()->count();
        $factors = DB::table('factors')->pluck('id')->count();
        $users = DB::table('users')->pluck('id')->count();
        return view('admin.dashboard', compact('headertext', 'notifs', 'users', 'factors'));
    }
    function adduser()
    {
        $headertext = 'افزودن کاربر';
        return view('admin.adduser', compact('headertext'));
    }
    function addusercheck(Request $request)
    {
        $request->validate([
            'name' => 'required|min:3',
            'phone' => 'required|unique:users|digits:11|numeric|regex:/(09)[0-9]{9}/',
            'usercode' => 'required|unique:users|numeric',
        ], [
            'name.required' => 'لطفا نام را وارد نمایید',
            'name.min' => 'نام حداقل باید ۳ حرف باشد',
            'phone.required' => 'لطفا شماره تلفن را وارد نمایید',
            'phone.unique' => 'این شماره تلفن قبلا در سیستم ثبت شده است',
            'phone.regex' => 'شماره تلفن باید با 09 شروع شود',
            'phone.digits' => 'شماره تلفن باید ۱۱ رقم باشد',
            'phone.numeric' => 'شماره تلفن نامعتبر است',
            'usercode.required' => 'لطفا کدپرسنلی را وارد نمایید',
            'usercode.unique' => 'این کدپرسنلی قبلا در سیستم ثبت شده است',
            'usercode.numeric' => 'کدپرسنلی باید عدد باشد',
        ]);

        $q = DB::table('users')->insert([
            'name' => $request->name,
            'phone' => $request->phone,
            'usercode' => $request->usercode,
        ]);

        if ($q) {
            return back()->with('message', 'کاربر با موفقیت افزوده شد');
        }
    }

    function userslists(Request $request)
    {
        $headertext = 'لیست کاربران';
        $type = $request->type;
        if (!isset($request->type) && !isset($request->inp)) {
            $users = DB::table('users')->orderBy('id', 'DESC')->paginate(50);
            return view('admin.userlists', compact('users', 'headertext'));
        } else {
            switch ($request->type) {
                case '1':
                    $users = DB::table('users')->where('name', 'like', '%' . $request->inp . '%')->paginate(50);

                    break;
                case '2':
                    $users = DB::table('users')->where('phone', 'like', '%' . $request->inp . '%')->paginate(50);

                    break;
                case '3':
                    $users = DB::table('users')->where('usercode', 'like', '%' . $request->inp . '%')->paginate(50);

                    break;

                default:
                    $users = DB::table('users')->orderBy('id', 'DESC')->paginate(50);
                    break;
            }
            return view('admin.userlists', compact('users', 'headertext', 'type'));
        }
    }
    function searchresult($users)
    {
        $headertext = 'لیست کاربران';
        return view('admin.searchresult', compact('users', 'headertext'));
    }

    function deleteuser($id)
    {
        DB::table('users')->where('id', '=', $id)->delete();
        return back();
    }

    function deletegroupusers(Request $request)
    {
        if (isset($request->deletedata)) {
            for ($i = 0; $i < count($request->deletedata); $i++) {
                // dd($request->deletedata[$i]);
                DB::table('users')->where('id', '=', $request->deletedata[$i])->delete();
            }
        }

        return back();
    }



    function addnotif()
    {
        $headertext = 'افزودن اطلاعیه';
        return view('admin.notif.addnotif', compact('headertext'));
    }

    function addnotifcheck(Request $request)
    {
        $request->validate([
            'desc' => 'required|min:3',
        ], [
            'desc.required' => 'لطفا متن اطلاعیه را وارد نمایید',
            'desc.min' => 'متن باید حداقل ۴ حرف باشد',

        ]);



        $q = DB::table('notification')->insert([
            'Desc' => $request->desc,
            'Tarikh' => Jalalian::now()->format('d %B Y'),
        ]);

        if ($q) {
            return back()->with('message', 'اطلاعیه با موفقیت افزوده شد');
        }
    }

    function notiflist()
    {
        $headertext = 'لیست اطلاعیه ها';
        $notifications = DB::table('notification')->orderBy('id', 'DESC')->get();
        return view('admin.notif.notiflist', compact('headertext', 'notifications'));
    }

    function notifdeletegroup(Request $request)
    {
        if (isset($request->deletedata)) {
            for ($i = 0; $i < count($request->deletedata); $i++) {
                $f = DB::table('notification')->where('id', '=', $request->deletedata[$i])->delete();
            }
        }

        return back();
    }

    function deletenotif($id)
    {

        DB::table('notification')->where('id', '=', $id)->delete();
        return back();
    }

    function adduserbyexcel()
    {
        $headertext = 'افزودن کاربر با اکسل';
        return view('admin.adduserbyexcel', compact('headertext'));
    }
    function adduserbyexcelcheck(Request $request)
    {

        $request->validate([
            'data' => 'required|mimes:xlsx|max:1024',
        ], [
            'data.required' => 'لطفا فایل کاربران را بارگزاری نمایید',
            'data.mimes' => 'فایل بارگزاری شده باید فرمت xlsx باشد',
            'data.max' => 'حجم فایل آپلود شده بیشتر از ۱ مگابایت میباشد',
        ]);


        $ex = SimpleXLSX::parseFile($request->data);

        $h = 0;


        // dd(count($ex->rows()[0]));


        if (count($ex->rows()[0]) == 3) {

            for ($q = 1; $q < count($ex->rows()); $q++) {



                $validator = Validator::make(
                    ['name' => $ex->rows()[$q][0], 'phone' => '0' . $ex->rows()[$q][1], 'usercode' => $ex->rows()[$q][2]],
                    ['name' => 'required|min:3', 'phone' => 'required|unique:users|digits:11|numeric|regex:/(09)[0-9]{9}/', 'usercode' => 'required|unique:users|numeric'],
                    [
                        'name.required' => 'لطفا نام را وارد نمایید. ( شماره سطر خطا : ' . $q . ')',
                        'name.min' => 'نام حداقل باید ۳ حرف باشد. ( شماره سطر خطا : ' . $q . ')',
                        'phone.required' => 'لطفا شماره تلفن را وارد نمایید. ( شماره سطر خطا : ' . $q . ')',
                        'phone.unique' => 'این شماره تلفن قبلا در سیستم ثبت شده است. ( شماره سطر خطا : ' . $q . ')',
                        'phone.regex' => 'شماره تلفن باید با 09 شروع شود. ( شماره سطر خطا : ' . $q . ')',
                        'phone.digits' => 'شماره تلفن باید ۱۱ رقم باشد. ( شماره سطر خطا : ' . $q . ')',
                        'phone.numeric' => 'شماره تلفن نامعتبر است. ( شماره سطر خطا : ' . $q . ')',
                        'usercode.required' => 'لطفا کدپرسنلی را وارد نمایید. ( شماره سطر خطا : ' . $q . ')',
                        'usercode.unique' => 'این کدپرسنلی قبلا در سیستم ثبت شده است. ( شماره سطر خطا : ' . $q . ')',
                        'usercode.numeric' => 'کدپرسنلی باید عدد باشد. ( شماره سطر خطا : ' . $q . ')',

                    ]
                );



                if ($validator->fails()) {
                    return back()->withErrors($validator);
                } else {
                    $a = DB::table('users')->insert([
                        'name' => $ex->rows()[$q][0],
                        'phone' => $ex->rows()[$q][1],
                        'usercode' => $ex->rows()[$q][2],
                    ]);
                    if ($a) {
                        $h++;
                    }
                }
            }

            return back()->with('message', 'تعداد' . ' ' . $h . ' ' . 'کاربر با موفقیت افزوده شد');
        } else {
            return back()->withErrors(['message' => 'تعداد ستون های فایل آپلود شده با تعداد اطلاعات کاربر مطابقت ندارد']);
        }
    }
}
