<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Factor;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Schema;
use Morilog\Jalali\Jalalian;
use Shuchkin\SimpleXLSX;
use Shuchkin\SimpleXLSXGen;
use Vtiful\Kernel\Excel;

class FactorController extends Controller
{
    function addfactor()
    {
        $headertext = 'افزودن فیش حقوقی';
        $year = Jalalian::now()->getYear();
        $month = Jalalian::now()->getMonth();
        return view('admin.factors.addfactor', compact('headertext', 'year', 'month'));
    }
    function addkarkard()
    {
        $headertext = 'افزودن کارکرد';
        $year = Jalalian::now()->getYear();
        $month = Jalalian::now()->getMonth();
        return view('admin.karkard.addkarkard', compact('headertext', 'year', 'month'));
    }

    function addfactorcheck(Request $request)
    {
        $request->validate([
            'data' => 'required|mimes:xlsx|max:1024',
        ], [
            'data.required' => 'لطفا فایل فیش های حقوقی را بارگزاری نمایید',
            'data.mimes' => 'فایل بارگزاری شده باید فرمت xlsx باشد',
            'data.max' => 'حجم فایل آپلود شده بیشتر از ۱ مگابایت میباشد',
        ]);

        // dd($request->data);
        // dd($request->file);
        $ex = SimpleXLSX::parseFile($request->data);
        $er = array($ex->rows());
        // $fac = count(Schema::getColumnListing('filds'));;
        $fac = DB::table('filds')->get()->toArray();


        // dd(count($ex->rows()[0]));

        $val['Tarikh'] = $request->mah . ' ' . $request->sal;
        $h = 0;

        if (count($ex->rows()[0]) == count($fac)) {

            for ($q = 1; $q < count($ex->rows()); $q++) {

                for ($i = 0; $i < count($ex->rows()[$q]); $i++) {
                    $val[$fac[$i]->Col] = $ex->rows()[$q][$i];
                }
                DB::table('factors')->insert($val);
                $h++;
            }

            return back()->with('message', 'تعداد' . ' ' . $h . ' ' . 'فیش حقوقی با موفقیت افزوده شد');
        } else {
            return back()->withErrors(['message' => 'تعداد ستون های فایل آپلود شده با تعداد فیلدهای فیش حقوقی برابر نیست']);
        }
    }
    function addkarkardcheck(Request $request)
    {
        $request->validate([
            'data' => 'required|mimes:xlsx|max:1024',
        ], [
            'data.required' => 'لطفا فایل کارکرد را بارگزاری نمایید',
            'data.mimes' => 'فایل بارگزاری شده باید فرمت xlsx باشد',
            'data.max' => 'حجم فایل آپلود شده بیشتر از ۱ مگابایت میباشد',
        ]);

        // dd($request->data);
        // dd($request->file);
        $ex = SimpleXLSX::parseFile($request->data);
        $er = array($ex->rows());
        // $fac = count(Schema::getColumnListing('filds'));;

        $fac = DB::table('karkardfilds')->get()->toArray();

        array_unshift($fac, 'Code', 'Salandmah');


        $h = 0;
        // dd(count($ex->rows()[0]));
        if (count($ex->rows()[0]) == count($fac)) {

            for ($q = 1; $q < count($ex->rows()); $q++) {

                for ($i = 0; $i < count($ex->rows()[$q]); $i++) {
                    // dd($fac[2]);

                    if ($i == 0) {
                        $val['Code'] = $ex->rows()[$q][0];
                    }
                    if ($i == 1) {
                        $val['Salandmah'] = $ex->rows()[$q][1];
                    }
                    if ($i >= 2) {
                        $val[$fac[$i]->Col] = $ex->rows()[$q][$i];
                    }


                    // dd($fac[$i]->Col);
                    // dd($val[$fac[$i]->Col]);
                }
                DB::table('karkard')->insert($val);
                $h++;
            }
            // dd($val);

            return back()->with('message', 'تعداد' . ' ' . $h . ' ' . 'کارکرد با موفقیت افزوده شد');
        } else {
            return back()->withErrors(['message' => 'تعداد ستون های فایل آپلود شده با تعداد فیلدهای کارکرد برابر نیست']);
        }
    }

    function factorlists(Request $request)
    {
        $headertext = 'لیست فیش های حقوقی';
        $filds = DB::table('filds')->get();
        $karkards = DB::table('karkard')->get();
        $type = $request->type;

        if (!isset($request->type) && !isset($request->inp)) {
            $factors = DB::table('factors')->orderBy('id', 'DESC')->paginate(50);
            return view('admin.factors.factorlist', compact('filds', 'karkards', 'factors', 'headertext'));
        } else {
            $w = DB::table('filds')->where('id', '=', $request->type)->first();
            // dd($w->Col);
            $factors = DB::table('factors')->where($w->Col, 'LIKE', '%' . $request->inp . '%')->orderBy('id', 'DESC')->paginate(50);
            return view('admin.factors.factorlist', compact('filds', 'karkards', 'factors', 'headertext', 'type'));
        }
    }

    function factorlistsbyuser($userid)
    {
        $user = DB::table('users')->where('id', '=', $userid)->first();
        $headertext = 'فیش های حقوقی ' . $user->name;
        $factors = DB::table('factors')->where('139db701fcb5abff6c356874bb57dac2a611c177', '=', $user->usercode)->orderBy('id', 'DESC')->get();
        return view('admin.factors.factorsbyuser', compact('headertext', 'factors'));
    }

    function deletegroupfactors(Request $request)
    {
        if (isset($request->deletedata)) {
            for ($i = 0; $i < count($request->deletedata); $i++) {
                $f = DB::table('factors')->where('id', '=', $request->deletedata[$i])->delete();
            }
        }

        return back();
    }

    function deletefactor($id)
    {
        $f = DB::table('factors')->where('id', '=', $id)->first();
        $karkard = DB::table('karkard')->where('Code', '=', $f->{'139db701fcb5abff6c356874bb57dac2a611c177'})->where('Salandmah', '=', $f->{'109f1caeaa9b1842b47bfdaf8255fddac6f1e0a3'})->delete();
        $f = DB::table('factors')->where('id', '=', $id)->delete();
        return back();
    }

    function showfactor($id)
    {
        $factor = DB::table('factors')->where('id', '=', $id)->first();
        $filds = DB::table('filds')->get();
        // dd($factor->{'139db701fcb5abff6c356874bb57dac2a611c177'});
        $headertext = 'فیش حقوقی ' . $factor->{'6d0a6b23037a8e4b3f78b3a42c0404a2b47eaa4f'} . '  (' . $factor->Tarikh . ')';
        $karkard = DB::table('karkard')->where('Code', '=', $factor->{'139db701fcb5abff6c356874bb57dac2a611c177'})->where('Salandmah', '=', $factor->{'109f1caeaa9b1842b47bfdaf8255fddac6f1e0a3'})->first();
        $karkardfilds = DB::table('karkardfilds')->get();
        // dd($karkard);
        return view('admin.factors.showfactor', compact('karkard', 'karkardfilds', 'filds', 'factor', 'headertext'));
    }

    function downloadfactorfild()
    {

        $data = [
            [],
        ];


        $filds = DB::table('filds')->get()->toArray();
        $b = '';
        foreach ($filds as $key => $fild) {

            array_push($data[0], $fild->Name);
        }
        SimpleXLSXGen::fromArray($data)->downloadAs('نمونه فایل اکسل فیش حقوقی سامانه فیش حقوقی.xlsx');
        return back();
    }

    function downloadkarkardfild()
    {

        $data = [
            ['کدپرسنلی', 'سال و ماه'],
        ];


        $filds = DB::table('karkardfilds')->get()->toArray();
        $b = '';
        foreach ($filds as $key => $fild) {

            array_push($data[0], $fild->Name);
        }
        SimpleXLSXGen::fromArray($data)->downloadAs('نمونه فایل اکسل کارکرد سامانه فیش حقوقی.xlsx');
        return back();
    }
}
