<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class FactorFildsController extends Controller
{

    function fildslists()
    {
        $headertext = 'لیست فیلدهای فیش حقوقی';
        $filds = DB::table('filds')->get();
        return view('admin.factors.fildslists', compact('filds', 'headertext'));
    }

    function deletefild($id)
    {
        $f = DB::table('filds')->where('Status', '!=', 3)->where('id', '=', $id)->first();
        if (isset($f)) {
            $deletecol = DB::statement("ALTER TABLE factors DROP COLUMN $f->Col");
            $f = DB::table('filds')->where('id', '=', $id)->delete();
            return back();
        } else {
            return redirect()->route('admin.factorfildslists');
        }
    }

    function deletegroupfilds(Request $request)
    {
        if (isset($request->deletedata)) {
            for ($i = 0; $i < count($request->deletedata); $i++) {
                // dd($request->deletedata[$i]);
                $f = DB::table('filds')->where('Status', '!=', 3)->where('id', '=', $request->deletedata[$i])->first();
                $deletecol = DB::statement("ALTER TABLE factors DROP COLUMN $f->Col");
                $f = DB::table('filds')->where('Status', '!=', 3)->where('id', '=', $request->deletedata[$i])->delete();
            }
        }

        return back();
    }

    function addfild()
    {
        $headertext = 'افزودن فیلد';
        return view('admin.factors.addfild', compact('headertext'));
    }
    function addfildcheck(Request $request)
    {
        $request->validate([
            'name' => 'required|min:3',
        ], [
            'name.required' => 'لطفا نام فیلد را وارد نمایید',
            'name.min' => 'نام فیلد حداقل باید ۳ حرف باشد',
        ]);

        $hash = sha1(rand() . microtime());


        switch ($request->type) {
            case '1':
                $addcol = DB::statement("ALTER TABLE factors ADD $hash int(11) DEFAULT 0;");
                break;

            case '2':
                $addcol = DB::statement("ALTER TABLE factors ADD $hash varchar(255) DEFAULT 'خالی';");
                break;
        }

        if ($addcol) {
            $query = DB::table('filds')->insert([
                'Name' => $request->name,
                'Type' => $request->type,
                'Status' => $request->status,
                'Col' => $hash,
            ]);
            if ($query) {
                return back()->with('message', 'فیلد با موفقیت افزوده شد');
            }
        } else {
            return back()->withError('مشکلی در افزودن پیش آمده است');
        }
    }
}
