<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class KarkardFildsController extends Controller
{
    function fildslists()
    {
        $headertext = 'لیست فیلدهای کارکرد';
        $filds = DB::table('karkardfilds')->get();
        return view('admin.karkard.fildslists', compact('filds', 'headertext'));
    }

    function deletefild($id)
    {
        $f = DB::table('karkardfilds')->where('id', '=', $id)->first();
        $deletecol = DB::statement("ALTER TABLE karkard DROP COLUMN $f->Col");
        $f = DB::table('karkardfilds')->where('id', '=', $id)->delete();
        return back();
    }



    function deletegroupfilds(Request $request)
    {
        if (isset($request->deletedata)) {
            for ($i = 0; $i < count($request->deletedata); $i++) {
                // dd($request->deletedata[$i]);
                $f = DB::table('karkardfilds')->where('id', '=', $request->deletedata[$i])->first();
                $deletecol = DB::statement("ALTER TABLE karkard DROP COLUMN $f->Col");
                $f = DB::table('karkardfilds')->where('id', '=', $request->deletedata[$i])->delete();
            }
        }

        return back();
    }

    function addfild()
    {
        $headertext = 'افزودن فیلد';
        return view('admin.karkard.addfild', compact('headertext'));
    }
    function addfildcheck(Request $request)
    {
        $request->validate([
            'name' => 'required|min:3',
        ], [
            'name.required' => 'لطفا نام فیلد را وارد نمایید',
            'name.min' => 'نام فیلد حداقل باید ۳ حرف باشد',
        ]);

        $hash = sha1(rand() . microtime());


        $addcol = DB::statement("ALTER TABLE karkard ADD $hash varchar(255) DEFAULT 0;");


        if ($addcol) {
            $query = DB::table('karkardfilds')->insert([
                'Name' => $request->name,
                'Col' => $hash,
            ]);
            if ($query) {
                return back()->with('message', 'فیلد با موفقیت افزوده شد');
            }
        } else {
            return back()->withErrors('message', 'مشکلی در افزودن پیش آمده است');
        }
    }
}
