@extends('panel.layouts.assets')

@section('content')
    <div class="account-pages my-5 pt-sm-5">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6 col-xl-5">
                    <div class="card overflow-hidden">
                        <div class="bg-login text-center">
                            <div class="bg-login-overlay"></div>
                            <div class="position-relative">
                                <h5 class="text-white font-size-20">خوش آمدید!</h5>
                                <p class="text-white-50 mb-0">ثبت نام در سامانه فیش حقوقی پاکان باختر بانه</p>
                                <a href="{{ route('index') }}" class="logo logo-admin mt-4">
                                    <img src="{{ asset('logo.png') }}" alt="" height="30">
                                </a>
                            </div>
                        </div>
                        <div class="card-body pt-5">
                            <div class="p-2">
                                <form class="form-horizontal" method="POST" action="{{ route('finalregister') }}">
                                    <div class="alert alert-info mb-0" role="alert"
                                        style="font-size: 10px;text-align: center">
                                        به دلیل نخستین ورود به حساب کاربری یک رمز عبور قوی برای حساب خود ثبت کنید
                                    </div>
                                    <br><br>
                                    @csrf


                                    <input style="display: none" name="usercode" value="{{ $usercode }}">

                                    <div class="form-group">
                                        <label for="phonenumber">شماره تلفن</label>
                                        <input style="text-align: center" name="phone" value="{{ old('phone') }}"
                                            type="phone" class="form-control" id="phonenumber" placeholder="09181234567">
                                    </div>

                                    <div class="form-group">
                                        <label for="password">رمز عبور</label>
                                        <input style="text-align: center" name="password" type="password"
                                            class="form-control" id="password" placeholder="رمز عبور">
                                    </div>
                                    <div class="form-group">
                                        <label for="password_confirmation">تکرار رمز عبور</label>
                                        <input style="text-align: center" name="password_confirmation" type="password"
                                            class="form-control" id="password_confirmation" placeholder="تکرار رمز عبور">
                                    </div>


                                    <div class="mt-3">
                                        <button class="btn btn-primary btn-block waves-effect waves-light"
                                            type="submit">نهایی کردن ثبت نام</button>
                                    </div>


                                </form>
                                <br>

                                <br><br>

                                @if ($errors->any())
                                    @foreach ($errors->all() as $error)
                                        <div style="text-align: center" class="alert alert-danger" role="alert">
                                            {{ $error }}
                                        </div>
                                    @endforeach
                                @endif

                                @if (session()->has('message'))
                                    <div style="text-align: center" class="t-center alert alert-danger" role="alert">
                                        {{ session()->get('message') }}
                                    </div>
                                @endif
                            </div>

                        </div>
                    </div>


                </div>
            </div>
        </div>
</div @endsection
